/**
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { GaxiosPromise } from 'gaxios';
import { Compute, JWT, OAuth2Client, UserRefreshClient } from 'google-auth-library';
import { APIRequestContext, BodyResponseCallback, GlobalOptions, GoogleConfigurable, MethodOptions } from 'googleapis-common';
export declare namespace bigtableadmin_v2 {
    interface Options extends GlobalOptions {
        version: 'v2';
    }
    interface StandardParameters {
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API
         * access, quota, and reports. Required unless you provide an OAuth 2.0
         * token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be
         * any arbitrary string assigned to a user, but should not exceed 40
         * characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Cloud Bigtable Admin API
     *
     * Administer your Cloud Bigtable tables and instances.
     *
     * @example
     * const {google} = require('googleapis');
     * const bigtableadmin = google.bigtableadmin('v2');
     *
     * @namespace bigtableadmin
     * @type {Function}
     * @version v2
     * @variation v2
     * @param {object=} options Options for Bigtableadmin
     */
    class Bigtableadmin {
        context: APIRequestContext;
        operations: Resource$Operations;
        projects: Resource$Projects;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * A configuration object describing how Cloud Bigtable should treat traffic
     * from a particular end user application.
     */
    interface Schema$AppProfile {
        /**
         * Optional long form description of the use case for this AppProfile.
         */
        description?: string;
        /**
         * Strongly validated etag for optimistic concurrency control. Preserve the
         * value returned from `GetAppProfile` when calling `UpdateAppProfile` to
         * fail the request if there has been a modification in the mean time. The
         * `update_mask` of the request need not include `etag` for this protection
         * to apply. See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
         * [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
         * details.
         */
        etag?: string;
        /**
         * Use a multi-cluster routing policy that may pick any cluster.
         */
        multiClusterRoutingUseAny?: Schema$MultiClusterRoutingUseAny;
        /**
         * (`OutputOnly`) The unique name of the app profile. Values are of the form
         * `projects/&lt;project&gt;/instances/&lt;instance&gt;/appProfiles/_a-zA-Z0-9*`.
         */
        name?: string;
        /**
         * Use a single-cluster routing policy.
         */
        singleClusterRouting?: Schema$SingleClusterRouting;
    }
    /**
     * Specifies the audit configuration for a service. The configuration
     * determines which permission types are logged, and what identities, if any,
     * are exempted from logging. An AuditConfig must have one or more
     * AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
     * specific service, the union of the two AuditConfigs is used for that
     * service: the log_types specified in each AuditConfig are enabled, and the
     * exempted_members in each AuditLogConfig are exempted.  Example Policy with
     * multiple AuditConfigs:      {       &quot;audit_configs&quot;: [         {
     * &quot;service&quot;: &quot;allServices&quot; &quot;audit_log_configs&quot;:
     * [             {               &quot;log_type&quot;: &quot;DATA_READ&quot;,
     * &quot;exempted_members&quot;: [ &quot;user:foo@gmail.com&quot; ] }, {
     * &quot;log_type&quot;: &quot;DATA_WRITE&quot;,             },             {
     * &quot;log_type&quot;: &quot;ADMIN_READ&quot;,             }           ] },
     * {           &quot;service&quot;: &quot;fooservice.googleapis.com&quot;
     * &quot;audit_log_configs&quot;: [             { &quot;log_type&quot;:
     * &quot;DATA_READ&quot;,             },             { &quot;log_type&quot;:
     * &quot;DATA_WRITE&quot;,               &quot;exempted_members&quot;: [
     * &quot;user:bar@gmail.com&quot;               ]             }           ] }
     * ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
     * ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
     * and bar@gmail.com from DATA_WRITE logging.
     */
    interface Schema$AuditConfig {
        /**
         * The configuration for logging of each type of permission.
         */
        auditLogConfigs?: Schema$AuditLogConfig[];
        /**
         * Specifies a service that will be enabled for audit logging. For example,
         * `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a
         * special value that covers all services.
         */
        service?: string;
    }
    /**
     * Provides the configuration for logging a type of permissions. Example: {
     * &quot;audit_log_configs&quot;: [         {           &quot;log_type&quot;:
     * &quot;DATA_READ&quot;,           &quot;exempted_members&quot;: [
     * &quot;user:foo@gmail.com&quot;           ]         },         {
     * &quot;log_type&quot;: &quot;DATA_WRITE&quot;,         }       ]     }  This
     * enables &#39;DATA_READ&#39; and &#39;DATA_WRITE&#39; logging, while
     * exempting foo@gmail.com from DATA_READ logging.
     */
    interface Schema$AuditLogConfig {
        /**
         * Specifies the identities that do not cause logging for this type of
         * permission. Follows the same format of Binding.members.
         */
        exemptedMembers?: string[];
        /**
         * The log type that this config enables.
         */
        logType?: string;
    }
    /**
     * Associates `members` with a `role`.
     */
    interface Schema$Binding {
        /**
         * Unimplemented. The condition that is associated with this binding. NOTE:
         * an unsatisfied condition will not allow user access via current binding.
         * Different bindings, including their conditions, are examined
         * independently.
         */
        condition?: Schema$Expr;
        /**
         * Specifies the identities requesting access for a Cloud Platform resource.
         * `members` can have the following values:  * `allUsers`: A special
         * identifier that represents anyone who is    on the internet; with or
         * without a Google account.  * `allAuthenticatedUsers`: A special
         * identifier that represents anyone    who is authenticated with a Google
         * account or a service account.  * `user:{emailid}`: An email address that
         * represents a specific Google    account. For example, `alice@gmail.com` .
         * * `serviceAccount:{emailid}`: An email address that represents a service
         * account. For example, `my-other-app@appspot.gserviceaccount.com`.  *
         * `group:{emailid}`: An email address that represents a Google group. For
         * example, `admins@example.com`.   * `domain:{domain}`: The G Suite domain
         * (primary) that represents all the    users of that domain. For example,
         * `google.com` or `example.com`.
         */
        members?: string[];
        /**
         * Role that is assigned to `members`. For example, `roles/viewer`,
         * `roles/editor`, or `roles/owner`.
         */
        role?: string;
    }
    /**
     * Request message for
     * google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency
     */
    interface Schema$CheckConsistencyRequest {
        /**
         * The token created using GenerateConsistencyToken for the Table.
         */
        consistencyToken?: string;
    }
    /**
     * Response message for
     * google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency
     */
    interface Schema$CheckConsistencyResponse {
        /**
         * True only if the token is consistent. A token is consistent if
         * replication has caught up with the restrictions specified in the request.
         */
        consistent?: boolean;
    }
    /**
     * A resizable group of nodes in a particular cloud location, capable of
     * serving all Tables in the parent Instance.
     */
    interface Schema$Cluster {
        /**
         * (`CreationOnly`) The type of storage used by this cluster to serve its
         * parent instance&#39;s tables, unless explicitly overridden.
         */
        defaultStorageType?: string;
        /**
         * (`CreationOnly`) The location where this cluster&#39;s nodes and storage
         * reside. For best performance, clients should be located as close as
         * possible to this cluster. Currently only zones are supported, so values
         * should be of the form `projects/&lt;project&gt;/locations/&lt;zone&gt;`.
         */
        location?: string;
        /**
         * (`OutputOnly`) The unique name of the cluster. Values are of the form
         * `projects/&lt;project&gt;/instances/&lt;instance&gt;/clusters/a-z*`.
         */
        name?: string;
        /**
         * The number of nodes allocated to this cluster. More nodes enable higher
         * throughput and more consistent performance.
         */
        serveNodes?: number;
        /**
         * (`OutputOnly`) The current state of the cluster.
         */
        state?: string;
    }
    /**
     * The state of a table&#39;s data in a particular cluster.
     */
    interface Schema$ClusterState {
        /**
         * Output only. The state of replication for the table in this cluster.
         */
        replicationState?: string;
    }
    /**
     * A set of columns within a table which share a common configuration.
     */
    interface Schema$ColumnFamily {
        /**
         * Garbage collection rule specified as a protobuf. Must serialize to at
         * most 500 bytes.  NOTE: Garbage collection executes opportunistically in
         * the background, and so it&#39;s possible for reads to return a cell even
         * if it matches the active GC expression for its family.
         */
        gcRule?: Schema$GcRule;
    }
    /**
     * The metadata for the Operation returned by CreateCluster.
     */
    interface Schema$CreateClusterMetadata {
        /**
         * The time at which the operation failed or was completed successfully.
         */
        finishTime?: string;
        /**
         * The request that prompted the initiation of this CreateCluster operation.
         */
        originalRequest?: Schema$CreateClusterRequest;
        /**
         * The time at which the original request was received.
         */
        requestTime?: string;
        /**
         * Keys: the full `name` of each table that existed in the instance when
         * CreateCluster was first called, i.e.
         * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
         * Any table added to the instance by a later API call will be created in
         * the new cluster by that API call, not this one.  Values: information on
         * how much of a table&#39;s data has been copied to the newly-created
         * cluster so far.
         */
        tables?: {
            [key: string]: Schema$TableProgress;
        };
    }
    /**
     * Request message for BigtableInstanceAdmin.CreateCluster.
     */
    interface Schema$CreateClusterRequest {
        /**
         * The cluster to be created. Fields marked `OutputOnly` must be left blank.
         */
        cluster?: Schema$Cluster;
        /**
         * The ID to be used when referring to the new cluster within its instance,
         * e.g., just `mycluster` rather than
         * `projects/myproject/instances/myinstance/clusters/mycluster`.
         */
        clusterId?: string;
        /**
         * The unique name of the instance in which to create the new cluster.
         * Values are of the form
         * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
         */
        parent?: string;
    }
    /**
     * The metadata for the Operation returned by CreateInstance.
     */
    interface Schema$CreateInstanceMetadata {
        /**
         * The time at which the operation failed or was completed successfully.
         */
        finishTime?: string;
        /**
         * The request that prompted the initiation of this CreateInstance
         * operation.
         */
        originalRequest?: Schema$CreateInstanceRequest;
        /**
         * The time at which the original request was received.
         */
        requestTime?: string;
    }
    /**
     * Request message for BigtableInstanceAdmin.CreateInstance.
     */
    interface Schema$CreateInstanceRequest {
        /**
         * The clusters to be created within the instance, mapped by desired cluster
         * ID, e.g., just `mycluster` rather than
         * `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
         * marked `OutputOnly` must be left blank. Currently, at most two clusters
         * can be specified.
         */
        clusters?: {
            [key: string]: Schema$Cluster;
        };
        /**
         * The instance to create. Fields marked `OutputOnly` must be left blank.
         */
        instance?: Schema$Instance;
        /**
         * The ID to be used when referring to the new instance within its project,
         * e.g., just `myinstance` rather than
         * `projects/myproject/instances/myinstance`.
         */
        instanceId?: string;
        /**
         * The unique name of the project in which to create the new instance.
         * Values are of the form `projects/&lt;project&gt;`.
         */
        parent?: string;
    }
    /**
     * Request message for google.bigtable.admin.v2.BigtableTableAdmin.CreateTable
     */
    interface Schema$CreateTableRequest {
        /**
         * The optional list of row keys that will be used to initially split the
         * table into several tablets (tablets are similar to HBase regions). Given
         * two split keys, `s1` and `s2`, three tablets will be created, spanning
         * the key ranges: `[, s1), [s1, s2), [s2, )`.  Example:  * Row keys :=
         * `[&quot;a&quot;, &quot;apple&quot;, &quot;custom&quot;,
         * &quot;customer_1&quot;, &quot;customer_2&quot;,` `&quot;other&quot;,
         * &quot;zz&quot;]` * initial_split_keys := `[&quot;apple&quot;,
         * &quot;customer_1&quot;, &quot;customer_2&quot;, &quot;other&quot;]` * Key
         * assignment:     - Tablet 1 `[, apple)                =&gt;
         * {&quot;a&quot;}.`     - Tablet 2 `[apple, customer_1)      =&gt;
         * {&quot;apple&quot;, &quot;custom&quot;}.`     - Tablet 3 `[customer_1,
         * customer_2) =&gt; {&quot;customer_1&quot;}.`     - Tablet 4 `[customer_2,
         * other)      =&gt; {&quot;customer_2&quot;}.`     - Tablet 5 `[other, )
         * =&gt; {&quot;other&quot;, &quot;zz&quot;}.`
         */
        initialSplits?: Schema$Split[];
        /**
         * The Table to create.
         */
        table?: Schema$Table;
        /**
         * The name by which the new table should be referred to within the parent
         * instance, e.g., `foobar` rather than `&lt;parent&gt;/tables/foobar`.
         */
        tableId?: string;
    }
    /**
     * Request message for
     * google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange
     */
    interface Schema$DropRowRangeRequest {
        /**
         * Delete all rows in the table. Setting this to false is a no-op.
         */
        deleteAllDataFromTable?: boolean;
        /**
         * Delete all rows that start with this row key prefix. Prefix cannot be
         * zero length.
         */
        rowKeyPrefix?: string;
    }
    /**
     * A generic empty message that you can re-use to avoid defining duplicated
     * empty messages in your APIs. A typical example is to use it as the request
     * or the response type of an API method. For instance:      service Foo { rpc
     * Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The JSON
     * representation for `Empty` is empty JSON object `{}`.
     */
    interface Schema$Empty {
    }
    /**
     * Represents an expression text. Example:      title: &quot;User account
     * presence&quot;     description: &quot;Determines whether the request has a
     * user account&quot;     expression: &quot;size(request.user) &gt; 0&quot;
     */
    interface Schema$Expr {
        /**
         * An optional description of the expression. This is a longer text which
         * describes the expression, e.g. when hovered over it in a UI.
         */
        description?: string;
        /**
         * Textual representation of an expression in Common Expression Language
         * syntax.  The application context of the containing message determines
         * which well-known feature set of CEL is supported.
         */
        expression?: string;
        /**
         * An optional string indicating the location of the expression for error
         * reporting, e.g. a file name and a position in the file.
         */
        location?: string;
        /**
         * An optional title for the expression, i.e. a short string describing its
         * purpose. This can be used e.g. in UIs which allow to enter the
         * expression.
         */
        title?: string;
    }
    /**
     * Rule for determining which cells to delete during garbage collection.
     */
    interface Schema$GcRule {
        /**
         * Delete cells that would be deleted by every nested rule.
         */
        intersection?: Schema$Intersection;
        /**
         * Delete cells in a column older than the given age. Values must be at
         * least one millisecond, and will be truncated to microsecond granularity.
         */
        maxAge?: string;
        /**
         * Delete all cells in a column except the most recent N.
         */
        maxNumVersions?: number;
        /**
         * Delete cells that would be deleted by any nested rule.
         */
        union?: Schema$Union;
    }
    /**
     * Request message for
     * google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken
     */
    interface Schema$GenerateConsistencyTokenRequest {
    }
    /**
     * Response message for
     * google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken
     */
    interface Schema$GenerateConsistencyTokenResponse {
        /**
         * The generated consistency token.
         */
        consistencyToken?: string;
    }
    /**
     * Request message for `GetIamPolicy` method.
     */
    interface Schema$GetIamPolicyRequest {
    }
    /**
     * A collection of Bigtable Tables and the resources that serve them. All
     * tables in an instance are served from all Clusters in the instance.
     */
    interface Schema$Instance {
        /**
         * The descriptive name for this instance as it appears in UIs. Can be
         * changed at any time, but should be kept globally unique to avoid
         * confusion.
         */
        displayName?: string;
        /**
         * Labels are a flexible and lightweight mechanism for organizing cloud
         * resources into groups that reflect a customer&#39;s organizational needs
         * and deployment strategies. They can be used to filter resources and
         * aggregate metrics.  * Label keys must be between 1 and 63 characters long
         * and must conform to   the regular expression: `\p{Ll}\p{Lo}{0,62}`. *
         * Label values must be between 0 and 63 characters long and must conform to
         * the regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`. * No more than 64
         * labels can be associated with a given resource. * Keys and values must
         * both be under 128 bytes.
         */
        labels?: {
            [key: string]: string;
        };
        /**
         * (`OutputOnly`) The unique name of the instance. Values are of the form
         * `projects/&lt;project&gt;/instances/a-z+[a-z0-9]`.
         */
        name?: string;
        /**
         * (`OutputOnly`) The current state of the instance.
         */
        state?: string;
        /**
         * The type of the instance. Defaults to `PRODUCTION`.
         */
        type?: string;
    }
    /**
     * A GcRule which deletes cells matching all of the given rules.
     */
    interface Schema$Intersection {
        /**
         * Only delete cells which would be deleted by every element of `rules`.
         */
        rules?: Schema$GcRule[];
    }
    /**
     * Response message for BigtableInstanceAdmin.ListAppProfiles.
     */
    interface Schema$ListAppProfilesResponse {
        /**
         * The list of requested app profiles.
         */
        appProfiles?: Schema$AppProfile[];
        /**
         * Locations from which AppProfile information could not be retrieved, due
         * to an outage or some other transient condition. AppProfiles from these
         * locations may be missing from `app_profiles`. Values are of the form
         * `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
         */
        failedLocations?: string[];
        /**
         * Set if not all app profiles could be returned in a single response. Pass
         * this value to `page_token` in another request to get the next page of
         * results.
         */
        nextPageToken?: string;
    }
    /**
     * Response message for BigtableInstanceAdmin.ListClusters.
     */
    interface Schema$ListClustersResponse {
        /**
         * The list of requested clusters.
         */
        clusters?: Schema$Cluster[];
        /**
         * Locations from which Cluster information could not be retrieved, due to
         * an outage or some other transient condition. Clusters from these
         * locations may be missing from `clusters`, or may only have partial
         * information returned. Values are of the form
         * `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
         */
        failedLocations?: string[];
        /**
         * DEPRECATED: This field is unused and ignored.
         */
        nextPageToken?: string;
    }
    /**
     * Response message for BigtableInstanceAdmin.ListInstances.
     */
    interface Schema$ListInstancesResponse {
        /**
         * Locations from which Instance information could not be retrieved, due to
         * an outage or some other transient condition. Instances whose Clusters are
         * all in one of the failed locations may be missing from `instances`, and
         * Instances with at least one Cluster in a failed location may only have
         * partial information returned. Values are of the form
         * `projects/&lt;project&gt;/locations/&lt;zone_id&gt;`
         */
        failedLocations?: string[];
        /**
         * The list of requested instances.
         */
        instances?: Schema$Instance[];
        /**
         * DEPRECATED: This field is unused and ignored.
         */
        nextPageToken?: string;
    }
    /**
     * The response message for Operations.ListOperations.
     */
    interface Schema$ListOperationsResponse {
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string;
        /**
         * A list of operations that matches the specified filter in the request.
         */
        operations?: Schema$Operation[];
    }
    /**
     * Response message for google.bigtable.admin.v2.BigtableTableAdmin.ListTables
     */
    interface Schema$ListTablesResponse {
        /**
         * Set if not all tables could be returned in a single response. Pass this
         * value to `page_token` in another request to get the next page of results.
         */
        nextPageToken?: string;
        /**
         * The tables present in the requested instance.
         */
        tables?: Schema$Table[];
    }
    /**
     * A create, update, or delete of a particular column family.
     */
    interface Schema$Modification {
        /**
         * Create a new column family with the specified schema, or fail if one
         * already exists with the given ID.
         */
        create?: Schema$ColumnFamily;
        /**
         * Drop (delete) the column family with the given ID, or fail if no such
         * family exists.
         */
        drop?: boolean;
        /**
         * The ID of the column family to be modified.
         */
        id?: string;
        /**
         * Update an existing column family to the specified schema, or fail if no
         * column family exists with the given ID.
         */
        update?: Schema$ColumnFamily;
    }
    /**
     * Request message for
     * google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies
     */
    interface Schema$ModifyColumnFamiliesRequest {
        /**
         * Modifications to be atomically applied to the specified table&#39;s
         * families. Entries are applied in order, meaning that earlier
         * modifications can be masked by later ones (in the case of repeated
         * updates to the same family, for example).
         */
        modifications?: Schema$Modification[];
    }
    /**
     * Read/write requests may be routed to any cluster in the instance, and will
     * fail over to another cluster in the event of transient errors or delays.
     * Choosing this option sacrifices read-your-writes consistency to improve
     * availability.
     */
    interface Schema$MultiClusterRoutingUseAny {
    }
    /**
     * This resource represents a long-running operation that is the result of a
     * network API call.
     */
    interface Schema$Operation {
        /**
         * If the value is `false`, it means the operation is still in progress. If
         * `true`, the operation is completed, and either `error` or `response` is
         * available.
         */
        done?: boolean;
        /**
         * The error result of the operation in case of failure or cancellation.
         */
        error?: Schema$Status;
        /**
         * Service-specific metadata associated with the operation.  It typically
         * contains progress information and common metadata such as create time.
         * Some services might not provide such metadata.  Any method that returns a
         * long-running operation should document the metadata type, if any.
         */
        metadata?: {
            [key: string]: any;
        };
        /**
         * The server-assigned name, which is only unique within the same service
         * that originally returns it. If you use the default HTTP mapping, the
         * `name` should have the format of `operations/some/unique/name`.
         */
        name?: string;
        /**
         * The normal response of the operation in case of success.  If the original
         * method returns no data on success, such as `Delete`, the response is
         * `google.protobuf.Empty`.  If the original method is standard
         * `Get`/`Create`/`Update`, the response should be the resource.  For other
         * methods, the response should have the type `XxxResponse`, where `Xxx` is
         * the original method name.  For example, if the original method name is
         * `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
         */
        response?: {
            [key: string]: any;
        };
    }
    /**
     * Request message for BigtableInstanceAdmin.PartialUpdateInstance.
     */
    interface Schema$PartialUpdateInstanceRequest {
        /**
         * The Instance which will (partially) replace the current value.
         */
        instance?: Schema$Instance;
        /**
         * The subset of Instance fields which should be replaced. Must be
         * explicitly set.
         */
        updateMask?: string;
    }
    /**
     * Defines an Identity and Access Management (IAM) policy. It is used to
     * specify access control policies for Cloud Platform resources.   A `Policy`
     * consists of a list of `bindings`. A `binding` binds a list of `members` to
     * a `role`, where the members can be user accounts, Google groups, Google
     * domains, and service accounts. A `role` is a named list of permissions
     * defined by IAM.  **JSON Example**      {       &quot;bindings&quot;: [ {
     * &quot;role&quot;: &quot;roles/owner&quot;,           &quot;members&quot;: [
     * &quot;user:mike@example.com&quot;, &quot;group:admins@example.com&quot;,
     * &quot;domain:google.com&quot;,
     * &quot;serviceAccount:my-other-app@appspot.gserviceaccount.com&quot; ] }, {
     * &quot;role&quot;: &quot;roles/viewer&quot;,           &quot;members&quot;:
     * [&quot;user:sean@example.com&quot;]         }       ]     }  **YAML
     * Example**      bindings:     - members:       - user:mike@example.com -
     * group:admins@example.com       - domain:google.com       -
     * serviceAccount:my-other-app@appspot.gserviceaccount.com       role:
     * roles/owner     - members:       - user:sean@example.com       role:
     * roles/viewer   For a description of IAM and its features, see the [IAM
     * developer&#39;s guide](https://cloud.google.com/iam/docs).
     */
    interface Schema$Policy {
        /**
         * Specifies cloud audit logging configuration for this policy.
         */
        auditConfigs?: Schema$AuditConfig[];
        /**
         * Associates a list of `members` to a `role`. `bindings` with no members
         * will result in an error.
         */
        bindings?: Schema$Binding[];
        /**
         * `etag` is used for optimistic concurrency control as a way to help
         * prevent simultaneous updates of a policy from overwriting each other. It
         * is strongly suggested that systems make use of the `etag` in the
         * read-modify-write cycle to perform policy updates in order to avoid race
         * conditions: An `etag` is returned in the response to `getIamPolicy`, and
         * systems are expected to put that etag in the request to `setIamPolicy` to
         * ensure that their change will be applied to the same version of the
         * policy.  If no `etag` is provided in the call to `setIamPolicy`, then the
         * existing policy is overwritten blindly.
         */
        etag?: string;
        /**
         * Deprecated.
         */
        version?: number;
    }
    /**
     * Request message for `SetIamPolicy` method.
     */
    interface Schema$SetIamPolicyRequest {
        /**
         * REQUIRED: The complete policy to be applied to the `resource`. The size
         * of the policy is limited to a few 10s of KB. An empty policy is a valid
         * policy but certain Cloud Platform services (such as Projects) might
         * reject them.
         */
        policy?: Schema$Policy;
        /**
         * OPTIONAL: A FieldMask specifying which fields of the policy to modify.
         * Only the fields in the mask will be modified. If no mask is provided, the
         * following default mask is used: paths: &quot;bindings, etag&quot; This
         * field is only used by Cloud IAM.
         */
        updateMask?: string;
    }
    /**
     * Unconditionally routes all read/write requests to a specific cluster. This
     * option preserves read-your-writes consistency, but does not improve
     * availability.
     */
    interface Schema$SingleClusterRouting {
        /**
         * Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are
         * allowed by this app profile. It is unsafe to send these requests to the
         * same table/row/column in multiple clusters.
         */
        allowTransactionalWrites?: boolean;
        /**
         * The cluster to which read/write requests should be routed.
         */
        clusterId?: string;
    }
    /**
     * An initial split point for a newly created table.
     */
    interface Schema$Split {
        /**
         * Row key to use as an initial tablet boundary.
         */
        key?: string;
    }
    /**
     * The `Status` type defines a logical error model that is suitable for
     * different programming environments, including REST APIs and RPC APIs. It is
     * used by [gRPC](https://github.com/grpc). The error model is designed to be:
     * - Simple to use and understand for most users - Flexible enough to meet
     * unexpected needs  # Overview  The `Status` message contains three pieces of
     * data: error code, error message, and error details. The error code should
     * be an enum value of google.rpc.Code, but it may accept additional error
     * codes if needed.  The error message should be a developer-facing English
     * message that helps developers *understand* and *resolve* the error. If a
     * localized user-facing error message is needed, put the localized message in
     * the error details or localize it in the client. The optional error details
     * may contain arbitrary information about the error. There is a predefined
     * set of error detail types in the package `google.rpc` that can be used for
     * common error conditions.  # Language mapping  The `Status` message is the
     * logical representation of the error model, but it is not necessarily the
     * actual wire format. When the `Status` message is exposed in different
     * client libraries and different wire protocols, it can be mapped
     * differently. For example, it will likely be mapped to some exceptions in
     * Java, but more likely mapped to some error codes in C.  # Other uses  The
     * error model and the `Status` message can be used in a variety of
     * environments, either with or without APIs, to provide a consistent
     * developer experience across different environments.  Example uses of this
     * error model include:  - Partial errors. If a service needs to return
     * partial errors to the client,     it may embed the `Status` in the normal
     * response to indicate the partial     errors.  - Workflow errors. A typical
     * workflow has multiple steps. Each step may     have a `Status` message for
     * error reporting.  - Batch operations. If a client uses batch request and
     * batch response, the     `Status` message should be used directly inside
     * batch response, one for     each error sub-response.  - Asynchronous
     * operations. If an API call embeds asynchronous operation     results in its
     * response, the status of those operations should be     represented directly
     * using the `Status` message.  - Logging. If some API errors are stored in
     * logs, the message `Status` could     be used directly after any stripping
     * needed for security/privacy reasons.
     */
    interface Schema$Status {
        /**
         * The status code, which should be an enum value of google.rpc.Code.
         */
        code?: number;
        /**
         * A list of messages that carry the error details.  There is a common set
         * of message types for APIs to use.
         */
        details?: Array<{
            [key: string]: any;
        }>;
        /**
         * A developer-facing error message, which should be in English. Any
         * user-facing error message should be localized and sent in the
         * google.rpc.Status.details field, or localized by the client.
         */
        message?: string;
    }
    /**
     * A collection of user data indexed by row, column, and timestamp. Each table
     * is served using the resources of its parent cluster.
     */
    interface Schema$Table {
        /**
         * Output only. Map from cluster ID to per-cluster table state. If it could
         * not be determined whether or not the table has data in a particular
         * cluster (for example, if its zone is unavailable), then there will be an
         * entry for the cluster with UNKNOWN `replication_status`. Views:
         * `REPLICATION_VIEW`, `FULL`
         */
        clusterStates?: {
            [key: string]: Schema$ClusterState;
        };
        /**
         * (`CreationOnly`) The column families configured for this table, mapped by
         * column family ID. Views: `SCHEMA_VIEW`, `FULL`
         */
        columnFamilies?: {
            [key: string]: Schema$ColumnFamily;
        };
        /**
         * (`CreationOnly`) The granularity (i.e. `MILLIS`) at which timestamps are
         * stored in this table. Timestamps not matching the granularity will be
         * rejected. If unspecified at creation time, the value will be set to
         * `MILLIS`. Views: `SCHEMA_VIEW`, `FULL`.
         */
        granularity?: string;
        /**
         * Output only. The unique name of the table. Values are of the form
         * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/_a-zA-Z0-9*`.
         * Views: `NAME_ONLY`, `SCHEMA_VIEW`, `REPLICATION_VIEW`, `FULL`
         */
        name?: string;
    }
    /**
     * Progress info for copying a table&#39;s data to the new cluster.
     */
    interface Schema$TableProgress {
        /**
         * Estimate of the number of bytes copied so far for this table. This will
         * eventually reach &#39;estimated_size_bytes&#39; unless the table copy is
         * CANCELLED.
         */
        estimatedCopiedBytes?: string;
        /**
         * Estimate of the size of the table to be copied.
         */
        estimatedSizeBytes?: string;
        state?: string;
    }
    /**
     * Request message for `TestIamPermissions` method.
     */
    interface Schema$TestIamPermissionsRequest {
        /**
         * The set of permissions to check for the `resource`. Permissions with
         * wildcards (such as &#39;*&#39; or &#39;storage.*&#39;) are not allowed.
         * For more information see [IAM
         * Overview](https://cloud.google.com/iam/docs/overview#permissions).
         */
        permissions?: string[];
    }
    /**
     * Response message for `TestIamPermissions` method.
     */
    interface Schema$TestIamPermissionsResponse {
        /**
         * A subset of `TestPermissionsRequest.permissions` that the caller is
         * allowed.
         */
        permissions?: string[];
    }
    /**
     * A GcRule which deletes cells matching any of the given rules.
     */
    interface Schema$Union {
        /**
         * Delete cells which would be deleted by any element of `rules`.
         */
        rules?: Schema$GcRule[];
    }
    /**
     * The metadata for the Operation returned by UpdateAppProfile.
     */
    interface Schema$UpdateAppProfileMetadata {
    }
    /**
     * The metadata for the Operation returned by UpdateCluster.
     */
    interface Schema$UpdateClusterMetadata {
        /**
         * The time at which the operation failed or was completed successfully.
         */
        finishTime?: string;
        /**
         * The request that prompted the initiation of this UpdateCluster operation.
         */
        originalRequest?: Schema$Cluster;
        /**
         * The time at which the original request was received.
         */
        requestTime?: string;
    }
    /**
     * The metadata for the Operation returned by UpdateInstance.
     */
    interface Schema$UpdateInstanceMetadata {
        /**
         * The time at which the operation failed or was completed successfully.
         */
        finishTime?: string;
        /**
         * The request that prompted the initiation of this UpdateInstance
         * operation.
         */
        originalRequest?: Schema$PartialUpdateInstanceRequest;
        /**
         * The time at which the original request was received.
         */
        requestTime?: string;
    }
    class Resource$Operations {
        context: APIRequestContext;
        projects: Resource$Operations$Projects;
        constructor(context: APIRequestContext);
        /**
         * bigtableadmin.operations.cancel
         * @desc Starts asynchronous cancellation on a long-running operation.  The
         * server makes a best effort to cancel the operation, but success is not
         * guaranteed.  If the server doesn't support this method, it returns
         * `google.rpc.Code.UNIMPLEMENTED`.  Clients can use Operations.GetOperation
         * or other methods to check whether the cancellation succeeded or whether
         * the operation completed despite cancellation. On successful cancellation,
         * the operation is not deleted; instead, it becomes an operation with an
         * Operation.error value with a google.rpc.Status.code of 1, corresponding
         * to `Code.CANCELLED`.
         * @alias bigtableadmin.operations.cancel
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The name of the operation resource to be cancelled.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        cancel(params?: Params$Resource$Operations$Cancel, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        cancel(params: Params$Resource$Operations$Cancel, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        cancel(params: Params$Resource$Operations$Cancel, callback: BodyResponseCallback<Schema$Empty>): void;
        cancel(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * bigtableadmin.operations.delete
         * @desc Deletes a long-running operation. This method indicates that the
         * client is no longer interested in the operation result. It does not
         * cancel the operation. If the server doesn't support this method, it
         * returns `google.rpc.Code.UNIMPLEMENTED`.
         * @alias bigtableadmin.operations.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The name of the operation resource to be deleted.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Operations$Delete, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        delete(params: Params$Resource$Operations$Delete, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(params: Params$Resource$Operations$Delete, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * bigtableadmin.operations.get
         * @desc Gets the latest state of a long-running operation.  Clients can use
         * this method to poll the operation result at intervals as recommended by
         * the API service.
         * @alias bigtableadmin.operations.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The name of the operation resource.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Operations$Get, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        get(params: Params$Resource$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        get(params: Params$Resource$Operations$Get, callback: BodyResponseCallback<Schema$Operation>): void;
        get(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    interface Params$Resource$Operations$Cancel extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The name of the operation resource to be cancelled.
         */
        name?: string;
    }
    interface Params$Resource$Operations$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The name of the operation resource to be deleted.
         */
        name?: string;
    }
    interface Params$Resource$Operations$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    class Resource$Operations$Projects {
        context: APIRequestContext;
        operations: Resource$Operations$Projects$Operations;
        constructor(context: APIRequestContext);
    }
    class Resource$Operations$Projects$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * bigtableadmin.operations.projects.operations.list
         * @desc Lists operations that match the specified filter in the request. If
         * the server doesn't support this method, it returns `UNIMPLEMENTED`. NOTE:
         * the `name` binding allows API services to override the binding to use
         * different resource name schemes, such as `users/x/operations`. To
         * override the binding, API services can add a binding such as
         * `"/v1/{name=users/x}/operations"` to their service configuration. For
         * backwards compatibility, the default name includes the operations
         * collection id, however overriding users must ensure the name binding is
         * the parent resource, without the operations collection id.
         * @alias bigtableadmin.operations.projects.operations.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.filter The standard list filter.
         * @param {string} params.name The name of the operation's parent resource.
         * @param {integer=} params.pageSize The standard list page size.
         * @param {string=} params.pageToken The standard list page token.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Operations$Projects$Operations$List, options?: MethodOptions): GaxiosPromise<Schema$ListOperationsResponse>;
        list(params: Params$Resource$Operations$Projects$Operations$List, options: MethodOptions | BodyResponseCallback<Schema$ListOperationsResponse>, callback: BodyResponseCallback<Schema$ListOperationsResponse>): void;
        list(params: Params$Resource$Operations$Projects$Operations$List, callback: BodyResponseCallback<Schema$ListOperationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListOperationsResponse>): void;
    }
    interface Params$Resource$Operations$Projects$Operations$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The name of the operation's parent resource.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
    }
    class Resource$Projects {
        context: APIRequestContext;
        instances: Resource$Projects$Instances;
        constructor(context: APIRequestContext);
    }
    class Resource$Projects$Instances {
        context: APIRequestContext;
        appProfiles: Resource$Projects$Instances$Appprofiles;
        clusters: Resource$Projects$Instances$Clusters;
        tables: Resource$Projects$Instances$Tables;
        constructor(context: APIRequestContext);
        /**
         * bigtableadmin.projects.instances.create
         * @desc Create an instance within a project.
         * @alias bigtableadmin.projects.instances.create
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.parent The unique name of the project in which to create the new instance. Values are of the form `projects/<project>`.
         * @param {().CreateInstanceRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        create(params?: Params$Resource$Projects$Instances$Create, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        create(params: Params$Resource$Projects$Instances$Create, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        create(params: Params$Resource$Projects$Instances$Create, callback: BodyResponseCallback<Schema$Operation>): void;
        create(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * bigtableadmin.projects.instances.delete
         * @desc Delete an instance from a project.
         * @alias bigtableadmin.projects.instances.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the instance to be deleted. Values are of the form `projects/<project>/instances/<instance>`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Projects$Instances$Delete, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        delete(params: Params$Resource$Projects$Instances$Delete, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(params: Params$Resource$Projects$Instances$Delete, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * bigtableadmin.projects.instances.get
         * @desc Gets information about an instance.
         * @alias bigtableadmin.projects.instances.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the requested instance. Values are of the form `projects/<project>/instances/<instance>`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Projects$Instances$Get, options?: MethodOptions): GaxiosPromise<Schema$Instance>;
        get(params: Params$Resource$Projects$Instances$Get, options: MethodOptions | BodyResponseCallback<Schema$Instance>, callback: BodyResponseCallback<Schema$Instance>): void;
        get(params: Params$Resource$Projects$Instances$Get, callback: BodyResponseCallback<Schema$Instance>): void;
        get(callback: BodyResponseCallback<Schema$Instance>): void;
        /**
         * bigtableadmin.projects.instances.getIamPolicy
         * @desc Gets the access control policy for an instance resource. Returns an
         * empty policy if an instance exists but does not have a policy set.
         * @alias bigtableadmin.projects.instances.getIamPolicy
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.resource_ REQUIRED: The resource for which the policy is being requested. See the operation documentation for the appropriate value for this field.
         * @param {().GetIamPolicyRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        getIamPolicy(params?: Params$Resource$Projects$Instances$Getiampolicy, options?: MethodOptions): GaxiosPromise<Schema$Policy>;
        getIamPolicy(params: Params$Resource$Projects$Instances$Getiampolicy, options: MethodOptions | BodyResponseCallback<Schema$Policy>, callback: BodyResponseCallback<Schema$Policy>): void;
        getIamPolicy(params: Params$Resource$Projects$Instances$Getiampolicy, callback: BodyResponseCallback<Schema$Policy>): void;
        getIamPolicy(callback: BodyResponseCallback<Schema$Policy>): void;
        /**
         * bigtableadmin.projects.instances.list
         * @desc Lists information about instances in a project.
         * @alias bigtableadmin.projects.instances.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.pageToken DEPRECATED: This field is unused and ignored.
         * @param {string} params.parent The unique name of the project for which a list of instances is requested. Values are of the form `projects/<project>`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Projects$Instances$List, options?: MethodOptions): GaxiosPromise<Schema$ListInstancesResponse>;
        list(params: Params$Resource$Projects$Instances$List, options: MethodOptions | BodyResponseCallback<Schema$ListInstancesResponse>, callback: BodyResponseCallback<Schema$ListInstancesResponse>): void;
        list(params: Params$Resource$Projects$Instances$List, callback: BodyResponseCallback<Schema$ListInstancesResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListInstancesResponse>): void;
        /**
         * bigtableadmin.projects.instances.partialUpdateInstance
         * @desc Partially updates an instance within a project. This method can
         * modify all fields of an Instance and is the preferred way to update an
         * Instance.
         * @alias bigtableadmin.projects.instances.partialUpdateInstance
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name (`OutputOnly`) The unique name of the instance. Values are of the form `projects/<project>/instances/a-z+[a-z0-9]`.
         * @param {string=} params.updateMask The subset of Instance fields which should be replaced. Must be explicitly set.
         * @param {().Instance} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        partialUpdateInstance(params?: Params$Resource$Projects$Instances$Partialupdateinstance, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        partialUpdateInstance(params: Params$Resource$Projects$Instances$Partialupdateinstance, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        partialUpdateInstance(params: Params$Resource$Projects$Instances$Partialupdateinstance, callback: BodyResponseCallback<Schema$Operation>): void;
        partialUpdateInstance(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * bigtableadmin.projects.instances.setIamPolicy
         * @desc Sets the access control policy on an instance resource. Replaces
         * any existing policy.
         * @alias bigtableadmin.projects.instances.setIamPolicy
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.resource_ REQUIRED: The resource for which the policy is being specified. See the operation documentation for the appropriate value for this field.
         * @param {().SetIamPolicyRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        setIamPolicy(params?: Params$Resource$Projects$Instances$Setiampolicy, options?: MethodOptions): GaxiosPromise<Schema$Policy>;
        setIamPolicy(params: Params$Resource$Projects$Instances$Setiampolicy, options: MethodOptions | BodyResponseCallback<Schema$Policy>, callback: BodyResponseCallback<Schema$Policy>): void;
        setIamPolicy(params: Params$Resource$Projects$Instances$Setiampolicy, callback: BodyResponseCallback<Schema$Policy>): void;
        setIamPolicy(callback: BodyResponseCallback<Schema$Policy>): void;
        /**
         * bigtableadmin.projects.instances.testIamPermissions
         * @desc Returns permissions that the caller has on the specified instance
         * resource.
         * @alias bigtableadmin.projects.instances.testIamPermissions
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.resource_ REQUIRED: The resource for which the policy detail is being requested. See the operation documentation for the appropriate value for this field.
         * @param {().TestIamPermissionsRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        testIamPermissions(params?: Params$Resource$Projects$Instances$Testiampermissions, options?: MethodOptions): GaxiosPromise<Schema$TestIamPermissionsResponse>;
        testIamPermissions(params: Params$Resource$Projects$Instances$Testiampermissions, options: MethodOptions | BodyResponseCallback<Schema$TestIamPermissionsResponse>, callback: BodyResponseCallback<Schema$TestIamPermissionsResponse>): void;
        testIamPermissions(params: Params$Resource$Projects$Instances$Testiampermissions, callback: BodyResponseCallback<Schema$TestIamPermissionsResponse>): void;
        testIamPermissions(callback: BodyResponseCallback<Schema$TestIamPermissionsResponse>): void;
        /**
         * bigtableadmin.projects.instances.update
         * @desc Updates an instance within a project. This method updates only the
         * display name and type for an Instance. To update other Instance
         * properties, such as labels, use PartialUpdateInstance.
         * @alias bigtableadmin.projects.instances.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name (`OutputOnly`) The unique name of the instance. Values are of the form `projects/<project>/instances/a-z+[a-z0-9]`.
         * @param {().Instance} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Projects$Instances$Update, options?: MethodOptions): GaxiosPromise<Schema$Instance>;
        update(params: Params$Resource$Projects$Instances$Update, options: MethodOptions | BodyResponseCallback<Schema$Instance>, callback: BodyResponseCallback<Schema$Instance>): void;
        update(params: Params$Resource$Projects$Instances$Update, callback: BodyResponseCallback<Schema$Instance>): void;
        update(callback: BodyResponseCallback<Schema$Instance>): void;
    }
    interface Params$Resource$Projects$Instances$Create extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the project in which to create the new instance.
         * Values are of the form `projects/<project>`.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$CreateInstanceRequest;
    }
    interface Params$Resource$Projects$Instances$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the instance to be deleted. Values are of the form
         * `projects/<project>/instances/<instance>`.
         */
        name?: string;
    }
    interface Params$Resource$Projects$Instances$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the requested instance. Values are of the form
         * `projects/<project>/instances/<instance>`.
         */
        name?: string;
    }
    interface Params$Resource$Projects$Instances$Getiampolicy extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * REQUIRED: The resource for which the policy is being requested. See the
         * operation documentation for the appropriate value for this field.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GetIamPolicyRequest;
    }
    interface Params$Resource$Projects$Instances$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * DEPRECATED: This field is unused and ignored.
         */
        pageToken?: string;
        /**
         * The unique name of the project for which a list of instances is
         * requested. Values are of the form `projects/<project>`.
         */
        parent?: string;
    }
    interface Params$Resource$Projects$Instances$Partialupdateinstance extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * (`OutputOnly`) The unique name of the instance. Values are of the form
         * `projects/<project>/instances/a-z+[a-z0-9]`.
         */
        name?: string;
        /**
         * The subset of Instance fields which should be replaced. Must be
         * explicitly set.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Instance;
    }
    interface Params$Resource$Projects$Instances$Setiampolicy extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * REQUIRED: The resource for which the policy is being specified. See the
         * operation documentation for the appropriate value for this field.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$SetIamPolicyRequest;
    }
    interface Params$Resource$Projects$Instances$Testiampermissions extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * REQUIRED: The resource for which the policy detail is being requested.
         * See the operation documentation for the appropriate value for this field.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$TestIamPermissionsRequest;
    }
    interface Params$Resource$Projects$Instances$Update extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * (`OutputOnly`) The unique name of the instance. Values are of the form
         * `projects/<project>/instances/a-z+[a-z0-9]`.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Instance;
    }
    class Resource$Projects$Instances$Appprofiles {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * bigtableadmin.projects.instances.appProfiles.create
         * @desc Creates an app profile within an instance.
         * @alias bigtableadmin.projects.instances.appProfiles.create
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.appProfileId The ID to be used when referring to the new app profile within its instance, e.g., just `myprofile` rather than `projects/myproject/instances/myinstance/appProfiles/myprofile`.
         * @param {boolean=} params.ignoreWarnings If true, ignore safety checks when creating the app profile.
         * @param {string} params.parent The unique name of the instance in which to create the new app profile. Values are of the form `projects/<project>/instances/<instance>`.
         * @param {().AppProfile} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        create(params?: Params$Resource$Projects$Instances$Appprofiles$Create, options?: MethodOptions): GaxiosPromise<Schema$AppProfile>;
        create(params: Params$Resource$Projects$Instances$Appprofiles$Create, options: MethodOptions | BodyResponseCallback<Schema$AppProfile>, callback: BodyResponseCallback<Schema$AppProfile>): void;
        create(params: Params$Resource$Projects$Instances$Appprofiles$Create, callback: BodyResponseCallback<Schema$AppProfile>): void;
        create(callback: BodyResponseCallback<Schema$AppProfile>): void;
        /**
         * bigtableadmin.projects.instances.appProfiles.delete
         * @desc Deletes an app profile from an instance.
         * @alias bigtableadmin.projects.instances.appProfiles.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {boolean=} params.ignoreWarnings If true, ignore safety checks when deleting the app profile.
         * @param {string} params.name The unique name of the app profile to be deleted. Values are of the form `projects/<project>/instances/<instance>/appProfiles/<app_profile>`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Projects$Instances$Appprofiles$Delete, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        delete(params: Params$Resource$Projects$Instances$Appprofiles$Delete, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(params: Params$Resource$Projects$Instances$Appprofiles$Delete, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * bigtableadmin.projects.instances.appProfiles.get
         * @desc Gets information about an app profile.
         * @alias bigtableadmin.projects.instances.appProfiles.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the requested app profile. Values are of the form `projects/<project>/instances/<instance>/appProfiles/<app_profile>`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Projects$Instances$Appprofiles$Get, options?: MethodOptions): GaxiosPromise<Schema$AppProfile>;
        get(params: Params$Resource$Projects$Instances$Appprofiles$Get, options: MethodOptions | BodyResponseCallback<Schema$AppProfile>, callback: BodyResponseCallback<Schema$AppProfile>): void;
        get(params: Params$Resource$Projects$Instances$Appprofiles$Get, callback: BodyResponseCallback<Schema$AppProfile>): void;
        get(callback: BodyResponseCallback<Schema$AppProfile>): void;
        /**
         * bigtableadmin.projects.instances.appProfiles.list
         * @desc Lists information about app profiles in an instance.
         * @alias bigtableadmin.projects.instances.appProfiles.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.pageSize Maximum number of results per page. CURRENTLY UNIMPLEMENTED AND IGNORED.
         * @param {string=} params.pageToken The value of `next_page_token` returned by a previous call.
         * @param {string} params.parent The unique name of the instance for which a list of app profiles is requested. Values are of the form `projects/<project>/instances/<instance>`. Use `<instance> = '-'` to list AppProfiles for all Instances in a project, e.g., `projects/myproject/instances/-`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Projects$Instances$Appprofiles$List, options?: MethodOptions): GaxiosPromise<Schema$ListAppProfilesResponse>;
        list(params: Params$Resource$Projects$Instances$Appprofiles$List, options: MethodOptions | BodyResponseCallback<Schema$ListAppProfilesResponse>, callback: BodyResponseCallback<Schema$ListAppProfilesResponse>): void;
        list(params: Params$Resource$Projects$Instances$Appprofiles$List, callback: BodyResponseCallback<Schema$ListAppProfilesResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListAppProfilesResponse>): void;
        /**
         * bigtableadmin.projects.instances.appProfiles.patch
         * @desc Updates an app profile within an instance.
         * @alias bigtableadmin.projects.instances.appProfiles.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {boolean=} params.ignoreWarnings If true, ignore safety checks when updating the app profile.
         * @param {string} params.name (`OutputOnly`) The unique name of the app profile. Values are of the form `projects/<project>/instances/<instance>/appProfiles/_a-zA-Z0-9*`.
         * @param {string=} params.updateMask The subset of app profile fields which should be replaced. If unset, all fields will be replaced.
         * @param {().AppProfile} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Projects$Instances$Appprofiles$Patch, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        patch(params: Params$Resource$Projects$Instances$Appprofiles$Patch, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(params: Params$Resource$Projects$Instances$Appprofiles$Patch, callback: BodyResponseCallback<Schema$Operation>): void;
        patch(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    interface Params$Resource$Projects$Instances$Appprofiles$Create extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The ID to be used when referring to the new app profile within its
         * instance, e.g., just `myprofile` rather than
         * `projects/myproject/instances/myinstance/appProfiles/myprofile`.
         */
        appProfileId?: string;
        /**
         * If true, ignore safety checks when creating the app profile.
         */
        ignoreWarnings?: boolean;
        /**
         * The unique name of the instance in which to create the new app profile.
         * Values are of the form `projects/<project>/instances/<instance>`.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$AppProfile;
    }
    interface Params$Resource$Projects$Instances$Appprofiles$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * If true, ignore safety checks when deleting the app profile.
         */
        ignoreWarnings?: boolean;
        /**
         * The unique name of the app profile to be deleted. Values are of the form
         * `projects/<project>/instances/<instance>/appProfiles/<app_profile>`.
         */
        name?: string;
    }
    interface Params$Resource$Projects$Instances$Appprofiles$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the requested app profile. Values are of the form
         * `projects/<project>/instances/<instance>/appProfiles/<app_profile>`.
         */
        name?: string;
    }
    interface Params$Resource$Projects$Instances$Appprofiles$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Maximum number of results per page. CURRENTLY UNIMPLEMENTED AND IGNORED.
         */
        pageSize?: number;
        /**
         * The value of `next_page_token` returned by a previous call.
         */
        pageToken?: string;
        /**
         * The unique name of the instance for which a list of app profiles is
         * requested. Values are of the form
         * `projects/<project>/instances/<instance>`. Use `<instance> = '-'` to list
         * AppProfiles for all Instances in a project, e.g.,
         * `projects/myproject/instances/-`.
         */
        parent?: string;
    }
    interface Params$Resource$Projects$Instances$Appprofiles$Patch extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * If true, ignore safety checks when updating the app profile.
         */
        ignoreWarnings?: boolean;
        /**
         * (`OutputOnly`) The unique name of the app profile. Values are of the form
         * `projects/<project>/instances/<instance>/appProfiles/_a-zA-Z0-9*`.
         */
        name?: string;
        /**
         * The subset of app profile fields which should be replaced. If unset, all
         * fields will be replaced.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$AppProfile;
    }
    class Resource$Projects$Instances$Clusters {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * bigtableadmin.projects.instances.clusters.create
         * @desc Creates a cluster within an instance.
         * @alias bigtableadmin.projects.instances.clusters.create
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.clusterId The ID to be used when referring to the new cluster within its instance, e.g., just `mycluster` rather than `projects/myproject/instances/myinstance/clusters/mycluster`.
         * @param {string} params.parent The unique name of the instance in which to create the new cluster. Values are of the form `projects/<project>/instances/<instance>`.
         * @param {().Cluster} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        create(params?: Params$Resource$Projects$Instances$Clusters$Create, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        create(params: Params$Resource$Projects$Instances$Clusters$Create, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        create(params: Params$Resource$Projects$Instances$Clusters$Create, callback: BodyResponseCallback<Schema$Operation>): void;
        create(callback: BodyResponseCallback<Schema$Operation>): void;
        /**
         * bigtableadmin.projects.instances.clusters.delete
         * @desc Deletes a cluster from an instance.
         * @alias bigtableadmin.projects.instances.clusters.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the cluster to be deleted. Values are of the form `projects/<project>/instances/<instance>/clusters/<cluster>`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Projects$Instances$Clusters$Delete, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        delete(params: Params$Resource$Projects$Instances$Clusters$Delete, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(params: Params$Resource$Projects$Instances$Clusters$Delete, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * bigtableadmin.projects.instances.clusters.get
         * @desc Gets information about a cluster.
         * @alias bigtableadmin.projects.instances.clusters.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the requested cluster. Values are of the form `projects/<project>/instances/<instance>/clusters/<cluster>`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Projects$Instances$Clusters$Get, options?: MethodOptions): GaxiosPromise<Schema$Cluster>;
        get(params: Params$Resource$Projects$Instances$Clusters$Get, options: MethodOptions | BodyResponseCallback<Schema$Cluster>, callback: BodyResponseCallback<Schema$Cluster>): void;
        get(params: Params$Resource$Projects$Instances$Clusters$Get, callback: BodyResponseCallback<Schema$Cluster>): void;
        get(callback: BodyResponseCallback<Schema$Cluster>): void;
        /**
         * bigtableadmin.projects.instances.clusters.list
         * @desc Lists information about clusters in an instance.
         * @alias bigtableadmin.projects.instances.clusters.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.pageToken DEPRECATED: This field is unused and ignored.
         * @param {string} params.parent The unique name of the instance for which a list of clusters is requested. Values are of the form `projects/<project>/instances/<instance>`. Use `<instance> = '-'` to list Clusters for all Instances in a project, e.g., `projects/myproject/instances/-`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Projects$Instances$Clusters$List, options?: MethodOptions): GaxiosPromise<Schema$ListClustersResponse>;
        list(params: Params$Resource$Projects$Instances$Clusters$List, options: MethodOptions | BodyResponseCallback<Schema$ListClustersResponse>, callback: BodyResponseCallback<Schema$ListClustersResponse>): void;
        list(params: Params$Resource$Projects$Instances$Clusters$List, callback: BodyResponseCallback<Schema$ListClustersResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListClustersResponse>): void;
        /**
         * bigtableadmin.projects.instances.clusters.update
         * @desc Updates a cluster within an instance.
         * @alias bigtableadmin.projects.instances.clusters.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name (`OutputOnly`) The unique name of the cluster. Values are of the form `projects/<project>/instances/<instance>/clusters/a-z*`.
         * @param {().Cluster} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Projects$Instances$Clusters$Update, options?: MethodOptions): GaxiosPromise<Schema$Operation>;
        update(params: Params$Resource$Projects$Instances$Clusters$Update, options: MethodOptions | BodyResponseCallback<Schema$Operation>, callback: BodyResponseCallback<Schema$Operation>): void;
        update(params: Params$Resource$Projects$Instances$Clusters$Update, callback: BodyResponseCallback<Schema$Operation>): void;
        update(callback: BodyResponseCallback<Schema$Operation>): void;
    }
    interface Params$Resource$Projects$Instances$Clusters$Create extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The ID to be used when referring to the new cluster within its instance,
         * e.g., just `mycluster` rather than
         * `projects/myproject/instances/myinstance/clusters/mycluster`.
         */
        clusterId?: string;
        /**
         * The unique name of the instance in which to create the new cluster.
         * Values are of the form `projects/<project>/instances/<instance>`.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Cluster;
    }
    interface Params$Resource$Projects$Instances$Clusters$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the cluster to be deleted. Values are of the form
         * `projects/<project>/instances/<instance>/clusters/<cluster>`.
         */
        name?: string;
    }
    interface Params$Resource$Projects$Instances$Clusters$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the requested cluster. Values are of the form
         * `projects/<project>/instances/<instance>/clusters/<cluster>`.
         */
        name?: string;
    }
    interface Params$Resource$Projects$Instances$Clusters$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * DEPRECATED: This field is unused and ignored.
         */
        pageToken?: string;
        /**
         * The unique name of the instance for which a list of clusters is
         * requested. Values are of the form
         * `projects/<project>/instances/<instance>`. Use `<instance> = '-'` to list
         * Clusters for all Instances in a project, e.g.,
         * `projects/myproject/instances/-`.
         */
        parent?: string;
    }
    interface Params$Resource$Projects$Instances$Clusters$Update extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * (`OutputOnly`) The unique name of the cluster. Values are of the form
         * `projects/<project>/instances/<instance>/clusters/a-z*`.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Cluster;
    }
    class Resource$Projects$Instances$Tables {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * bigtableadmin.projects.instances.tables.checkConsistency
         * @desc Checks replication consistency based on a consistency token, that
         * is, if replication has caught up based on the conditions specified in the
         * token and the check request.
         * @alias bigtableadmin.projects.instances.tables.checkConsistency
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the Table for which to check replication consistency. Values are of the form `projects/<project>/instances/<instance>/tables/<table>`.
         * @param {().CheckConsistencyRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        checkConsistency(params?: Params$Resource$Projects$Instances$Tables$Checkconsistency, options?: MethodOptions): GaxiosPromise<Schema$CheckConsistencyResponse>;
        checkConsistency(params: Params$Resource$Projects$Instances$Tables$Checkconsistency, options: MethodOptions | BodyResponseCallback<Schema$CheckConsistencyResponse>, callback: BodyResponseCallback<Schema$CheckConsistencyResponse>): void;
        checkConsistency(params: Params$Resource$Projects$Instances$Tables$Checkconsistency, callback: BodyResponseCallback<Schema$CheckConsistencyResponse>): void;
        checkConsistency(callback: BodyResponseCallback<Schema$CheckConsistencyResponse>): void;
        /**
         * bigtableadmin.projects.instances.tables.create
         * @desc Creates a new table in the specified instance. The table can be
         * created with a full set of initial column families, specified in the
         * request.
         * @alias bigtableadmin.projects.instances.tables.create
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.parent The unique name of the instance in which to create the table. Values are of the form `projects/<project>/instances/<instance>`.
         * @param {().CreateTableRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        create(params?: Params$Resource$Projects$Instances$Tables$Create, options?: MethodOptions): GaxiosPromise<Schema$Table>;
        create(params: Params$Resource$Projects$Instances$Tables$Create, options: MethodOptions | BodyResponseCallback<Schema$Table>, callback: BodyResponseCallback<Schema$Table>): void;
        create(params: Params$Resource$Projects$Instances$Tables$Create, callback: BodyResponseCallback<Schema$Table>): void;
        create(callback: BodyResponseCallback<Schema$Table>): void;
        /**
         * bigtableadmin.projects.instances.tables.delete
         * @desc Permanently deletes a specified table and all of its data.
         * @alias bigtableadmin.projects.instances.tables.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the table to be deleted. Values are of the form `projects/<project>/instances/<instance>/tables/<table>`.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Projects$Instances$Tables$Delete, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        delete(params: Params$Resource$Projects$Instances$Tables$Delete, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(params: Params$Resource$Projects$Instances$Tables$Delete, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * bigtableadmin.projects.instances.tables.dropRowRange
         * @desc Permanently drop/delete a row range from a specified table. The
         * request can specify whether to delete all rows in a table, or only those
         * that match a particular prefix.
         * @alias bigtableadmin.projects.instances.tables.dropRowRange
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the table on which to drop a range of rows. Values are of the form `projects/<project>/instances/<instance>/tables/<table>`.
         * @param {().DropRowRangeRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        dropRowRange(params?: Params$Resource$Projects$Instances$Tables$Droprowrange, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        dropRowRange(params: Params$Resource$Projects$Instances$Tables$Droprowrange, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        dropRowRange(params: Params$Resource$Projects$Instances$Tables$Droprowrange, callback: BodyResponseCallback<Schema$Empty>): void;
        dropRowRange(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * bigtableadmin.projects.instances.tables.generateConsistencyToken
         * @desc Generates a consistency token for a Table, which can be used in
         * CheckConsistency to check whether mutations to the table that finished
         * before this call started have been replicated. The tokens will be
         * available for 90 days.
         * @alias bigtableadmin.projects.instances.tables.generateConsistencyToken
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the Table for which to create a consistency token. Values are of the form `projects/<project>/instances/<instance>/tables/<table>`.
         * @param {().GenerateConsistencyTokenRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        generateConsistencyToken(params?: Params$Resource$Projects$Instances$Tables$Generateconsistencytoken, options?: MethodOptions): GaxiosPromise<Schema$GenerateConsistencyTokenResponse>;
        generateConsistencyToken(params: Params$Resource$Projects$Instances$Tables$Generateconsistencytoken, options: MethodOptions | BodyResponseCallback<Schema$GenerateConsistencyTokenResponse>, callback: BodyResponseCallback<Schema$GenerateConsistencyTokenResponse>): void;
        generateConsistencyToken(params: Params$Resource$Projects$Instances$Tables$Generateconsistencytoken, callback: BodyResponseCallback<Schema$GenerateConsistencyTokenResponse>): void;
        generateConsistencyToken(callback: BodyResponseCallback<Schema$GenerateConsistencyTokenResponse>): void;
        /**
         * bigtableadmin.projects.instances.tables.get
         * @desc Gets metadata information about the specified table.
         * @alias bigtableadmin.projects.instances.tables.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the requested table. Values are of the form `projects/<project>/instances/<instance>/tables/<table>`.
         * @param {string=} params.view The view to be applied to the returned table's fields. Defaults to `SCHEMA_VIEW` if unspecified.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Projects$Instances$Tables$Get, options?: MethodOptions): GaxiosPromise<Schema$Table>;
        get(params: Params$Resource$Projects$Instances$Tables$Get, options: MethodOptions | BodyResponseCallback<Schema$Table>, callback: BodyResponseCallback<Schema$Table>): void;
        get(params: Params$Resource$Projects$Instances$Tables$Get, callback: BodyResponseCallback<Schema$Table>): void;
        get(callback: BodyResponseCallback<Schema$Table>): void;
        /**
         * bigtableadmin.projects.instances.tables.getIamPolicy
         * @desc Gets the access control policy for an instance resource. Returns an
         * empty policy if an table exists but does not have a policy set.
         * @alias bigtableadmin.projects.instances.tables.getIamPolicy
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.resource_ REQUIRED: The resource for which the policy is being requested. See the operation documentation for the appropriate value for this field.
         * @param {().GetIamPolicyRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        getIamPolicy(params?: Params$Resource$Projects$Instances$Tables$Getiampolicy, options?: MethodOptions): GaxiosPromise<Schema$Policy>;
        getIamPolicy(params: Params$Resource$Projects$Instances$Tables$Getiampolicy, options: MethodOptions | BodyResponseCallback<Schema$Policy>, callback: BodyResponseCallback<Schema$Policy>): void;
        getIamPolicy(params: Params$Resource$Projects$Instances$Tables$Getiampolicy, callback: BodyResponseCallback<Schema$Policy>): void;
        getIamPolicy(callback: BodyResponseCallback<Schema$Policy>): void;
        /**
         * bigtableadmin.projects.instances.tables.list
         * @desc Lists all tables served from a specified instance.
         * @alias bigtableadmin.projects.instances.tables.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.pageSize Maximum number of results per page. CURRENTLY UNIMPLEMENTED AND IGNORED.
         * @param {string=} params.pageToken The value of `next_page_token` returned by a previous call.
         * @param {string} params.parent The unique name of the instance for which tables should be listed. Values are of the form `projects/<project>/instances/<instance>`.
         * @param {string=} params.view The view to be applied to the returned tables' fields. Defaults to `NAME_ONLY` if unspecified; no others are currently supported.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Projects$Instances$Tables$List, options?: MethodOptions): GaxiosPromise<Schema$ListTablesResponse>;
        list(params: Params$Resource$Projects$Instances$Tables$List, options: MethodOptions | BodyResponseCallback<Schema$ListTablesResponse>, callback: BodyResponseCallback<Schema$ListTablesResponse>): void;
        list(params: Params$Resource$Projects$Instances$Tables$List, callback: BodyResponseCallback<Schema$ListTablesResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListTablesResponse>): void;
        /**
         * bigtableadmin.projects.instances.tables.modifyColumnFamilies
         * @desc Performs a series of column family modifications on the specified
         * table. Either all or none of the modifications will occur before this
         * method returns, but data requests received prior to that point may see a
         * table where only some modifications have taken effect.
         * @alias bigtableadmin.projects.instances.tables.modifyColumnFamilies
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.name The unique name of the table whose families should be modified. Values are of the form `projects/<project>/instances/<instance>/tables/<table>`.
         * @param {().ModifyColumnFamiliesRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        modifyColumnFamilies(params?: Params$Resource$Projects$Instances$Tables$Modifycolumnfamilies, options?: MethodOptions): GaxiosPromise<Schema$Table>;
        modifyColumnFamilies(params: Params$Resource$Projects$Instances$Tables$Modifycolumnfamilies, options: MethodOptions | BodyResponseCallback<Schema$Table>, callback: BodyResponseCallback<Schema$Table>): void;
        modifyColumnFamilies(params: Params$Resource$Projects$Instances$Tables$Modifycolumnfamilies, callback: BodyResponseCallback<Schema$Table>): void;
        modifyColumnFamilies(callback: BodyResponseCallback<Schema$Table>): void;
        /**
         * bigtableadmin.projects.instances.tables.setIamPolicy
         * @desc Sets the access control policy on a table resource. Replaces any
         * existing policy.
         * @alias bigtableadmin.projects.instances.tables.setIamPolicy
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.resource_ REQUIRED: The resource for which the policy is being specified. See the operation documentation for the appropriate value for this field.
         * @param {().SetIamPolicyRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        setIamPolicy(params?: Params$Resource$Projects$Instances$Tables$Setiampolicy, options?: MethodOptions): GaxiosPromise<Schema$Policy>;
        setIamPolicy(params: Params$Resource$Projects$Instances$Tables$Setiampolicy, options: MethodOptions | BodyResponseCallback<Schema$Policy>, callback: BodyResponseCallback<Schema$Policy>): void;
        setIamPolicy(params: Params$Resource$Projects$Instances$Tables$Setiampolicy, callback: BodyResponseCallback<Schema$Policy>): void;
        setIamPolicy(callback: BodyResponseCallback<Schema$Policy>): void;
        /**
         * bigtableadmin.projects.instances.tables.testIamPermissions
         * @desc Returns permissions that the caller has on the specified table
         * resource.
         * @alias bigtableadmin.projects.instances.tables.testIamPermissions
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.resource_ REQUIRED: The resource for which the policy detail is being requested. See the operation documentation for the appropriate value for this field.
         * @param {().TestIamPermissionsRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        testIamPermissions(params?: Params$Resource$Projects$Instances$Tables$Testiampermissions, options?: MethodOptions): GaxiosPromise<Schema$TestIamPermissionsResponse>;
        testIamPermissions(params: Params$Resource$Projects$Instances$Tables$Testiampermissions, options: MethodOptions | BodyResponseCallback<Schema$TestIamPermissionsResponse>, callback: BodyResponseCallback<Schema$TestIamPermissionsResponse>): void;
        testIamPermissions(params: Params$Resource$Projects$Instances$Tables$Testiampermissions, callback: BodyResponseCallback<Schema$TestIamPermissionsResponse>): void;
        testIamPermissions(callback: BodyResponseCallback<Schema$TestIamPermissionsResponse>): void;
    }
    interface Params$Resource$Projects$Instances$Tables$Checkconsistency extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the Table for which to check replication consistency.
         * Values are of the form
         * `projects/<project>/instances/<instance>/tables/<table>`.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$CheckConsistencyRequest;
    }
    interface Params$Resource$Projects$Instances$Tables$Create extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the instance in which to create the table. Values are
         * of the form `projects/<project>/instances/<instance>`.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$CreateTableRequest;
    }
    interface Params$Resource$Projects$Instances$Tables$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the table to be deleted. Values are of the form
         * `projects/<project>/instances/<instance>/tables/<table>`.
         */
        name?: string;
    }
    interface Params$Resource$Projects$Instances$Tables$Droprowrange extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the table on which to drop a range of rows. Values are
         * of the form `projects/<project>/instances/<instance>/tables/<table>`.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$DropRowRangeRequest;
    }
    interface Params$Resource$Projects$Instances$Tables$Generateconsistencytoken extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the Table for which to create a consistency token.
         * Values are of the form
         * `projects/<project>/instances/<instance>/tables/<table>`.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GenerateConsistencyTokenRequest;
    }
    interface Params$Resource$Projects$Instances$Tables$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the requested table. Values are of the form
         * `projects/<project>/instances/<instance>/tables/<table>`.
         */
        name?: string;
        /**
         * The view to be applied to the returned table's fields. Defaults to
         * `SCHEMA_VIEW` if unspecified.
         */
        view?: string;
    }
    interface Params$Resource$Projects$Instances$Tables$Getiampolicy extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * REQUIRED: The resource for which the policy is being requested. See the
         * operation documentation for the appropriate value for this field.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GetIamPolicyRequest;
    }
    interface Params$Resource$Projects$Instances$Tables$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Maximum number of results per page. CURRENTLY UNIMPLEMENTED AND IGNORED.
         */
        pageSize?: number;
        /**
         * The value of `next_page_token` returned by a previous call.
         */
        pageToken?: string;
        /**
         * The unique name of the instance for which tables should be listed. Values
         * are of the form `projects/<project>/instances/<instance>`.
         */
        parent?: string;
        /**
         * The view to be applied to the returned tables' fields. Defaults to
         * `NAME_ONLY` if unspecified; no others are currently supported.
         */
        view?: string;
    }
    interface Params$Resource$Projects$Instances$Tables$Modifycolumnfamilies extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The unique name of the table whose families should be modified. Values
         * are of the form `projects/<project>/instances/<instance>/tables/<table>`.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ModifyColumnFamiliesRequest;
    }
    interface Params$Resource$Projects$Instances$Tables$Setiampolicy extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * REQUIRED: The resource for which the policy is being specified. See the
         * operation documentation for the appropriate value for this field.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$SetIamPolicyRequest;
    }
    interface Params$Resource$Projects$Instances$Tables$Testiampermissions extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * REQUIRED: The resource for which the policy detail is being requested.
         * See the operation documentation for the appropriate value for this field.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$TestIamPermissionsRequest;
    }
}
