/**
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { GaxiosPromise } from 'gaxios';
import { Compute, JWT, OAuth2Client, UserRefreshClient } from 'google-auth-library';
import { APIRequestContext, BodyResponseCallback, GlobalOptions, GoogleConfigurable, MethodOptions } from 'googleapis-common';
export declare namespace appstate_v1 {
    interface Options extends GlobalOptions {
        version: 'v1';
    }
    interface StandardParameters {
        /**
         * Data format for the response.
         */
        alt?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API
         * access, quota, and reports. Required unless you provide an OAuth 2.0
         * token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * An opaque string that represents a user for quota purposes. Must not
         * exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Deprecated. Please use quotaUser instead.
         */
        userIp?: string;
    }
    /**
     * Google App State API
     *
     * The Google App State API.
     *
     * @example
     * const {google} = require('googleapis');
     * const appstate = google.appstate('v1');
     *
     * @namespace appstate
     * @type {Function}
     * @version v1
     * @variation v1
     * @param {object=} options Options for Appstate
     */
    class Appstate {
        context: APIRequestContext;
        states: Resource$States;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * This is a JSON template for an app state resource.
     */
    interface Schema$GetResponse {
        /**
         * The current app state version.
         */
        currentStateVersion?: string;
        /**
         * The requested data.
         */
        data?: string;
        /**
         * Uniquely identifies the type of this resource. Value is always the fixed
         * string appstate#getResponse.
         */
        kind?: string;
        /**
         * The key for the data.
         */
        stateKey?: number;
    }
    /**
     * This is a JSON template to convert a list-response for app state.
     */
    interface Schema$ListResponse {
        /**
         * The app state data.
         */
        items?: Schema$GetResponse[];
        /**
         * Uniquely identifies the type of this resource. Value is always the fixed
         * string appstate#listResponse.
         */
        kind?: string;
        /**
         * The maximum number of keys allowed for this user.
         */
        maximumKeyCount?: number;
    }
    /**
     * This is a JSON template for a requests which update app state
     */
    interface Schema$UpdateRequest {
        /**
         * The new app state data that your application is trying to update with.
         */
        data?: string;
        /**
         * Uniquely identifies the type of this resource. Value is always the fixed
         * string appstate#updateRequest.
         */
        kind?: string;
    }
    /**
     * This is a JSON template for an app state write result.
     */
    interface Schema$WriteResult {
        /**
         * The version of the data for this key on the server.
         */
        currentStateVersion?: string;
        /**
         * Uniquely identifies the type of this resource. Value is always the fixed
         * string appstate#writeResult.
         */
        kind?: string;
        /**
         * The written key.
         */
        stateKey?: number;
    }
    class Resource$States {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * appstate.states.clear
         * @desc Clears (sets to empty) the data for the passed key if and only if
         * the passed version matches the currently stored version. This method
         * results in a conflict error on version mismatch.
         * @alias appstate.states.clear
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.currentDataVersion The version of the data to be cleared. Version strings are returned by the server.
         * @param {integer} params.stateKey The key for the data to be retrieved.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        clear(params?: Params$Resource$States$Clear, options?: MethodOptions): GaxiosPromise<Schema$WriteResult>;
        clear(params: Params$Resource$States$Clear, options: MethodOptions | BodyResponseCallback<Schema$WriteResult>, callback: BodyResponseCallback<Schema$WriteResult>): void;
        clear(params: Params$Resource$States$Clear, callback: BodyResponseCallback<Schema$WriteResult>): void;
        clear(callback: BodyResponseCallback<Schema$WriteResult>): void;
        /**
         * appstate.states.delete
         * @desc Deletes a key and the data associated with it. The key is removed
         * and no longer counts against the key quota. Note that since this method
         * is not safe in the face of concurrent modifications, it should only be
         * used for development and testing purposes. Invoking this method in
         * shipping code can result in data loss and data corruption.
         * @alias appstate.states.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.stateKey The key for the data to be retrieved.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$States$Delete, options?: MethodOptions): GaxiosPromise<void>;
        delete(params: Params$Resource$States$Delete, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        delete(params: Params$Resource$States$Delete, callback: BodyResponseCallback<void>): void;
        delete(callback: BodyResponseCallback<void>): void;
        /**
         * appstate.states.get
         * @desc Retrieves the data corresponding to the passed key. If the key does
         * not exist on the server, an HTTP 404 will be returned.
         * @alias appstate.states.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.stateKey The key for the data to be retrieved.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$States$Get, options?: MethodOptions): GaxiosPromise<Schema$GetResponse>;
        get(params: Params$Resource$States$Get, options: MethodOptions | BodyResponseCallback<Schema$GetResponse>, callback: BodyResponseCallback<Schema$GetResponse>): void;
        get(params: Params$Resource$States$Get, callback: BodyResponseCallback<Schema$GetResponse>): void;
        get(callback: BodyResponseCallback<Schema$GetResponse>): void;
        /**
         * appstate.states.list
         * @desc Lists all the states keys, and optionally the state data.
         * @alias appstate.states.list
         * @memberOf! ()
         *
         * @param {object=} params Parameters for request
         * @param {boolean=} params.includeData Whether to include the full data in addition to the version number
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$States$List, options?: MethodOptions): GaxiosPromise<Schema$ListResponse>;
        list(params: Params$Resource$States$List, options: MethodOptions | BodyResponseCallback<Schema$ListResponse>, callback: BodyResponseCallback<Schema$ListResponse>): void;
        list(params: Params$Resource$States$List, callback: BodyResponseCallback<Schema$ListResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListResponse>): void;
        /**
         * appstate.states.update
         * @desc Update the data associated with the input key if and only if the
         * passed version matches the currently stored version. This method is safe
         * in the face of concurrent writes. Maximum per-key size is 128KB.
         * @alias appstate.states.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.currentStateVersion The version of the app state your application is attempting to update. If this does not match the current version, this method will return a conflict error. If there is no data stored on the server for this key, the update will succeed irrespective of the value of this parameter.
         * @param {integer} params.stateKey The key for the data to be retrieved.
         * @param {().UpdateRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$States$Update, options?: MethodOptions): GaxiosPromise<Schema$WriteResult>;
        update(params: Params$Resource$States$Update, options: MethodOptions | BodyResponseCallback<Schema$WriteResult>, callback: BodyResponseCallback<Schema$WriteResult>): void;
        update(params: Params$Resource$States$Update, callback: BodyResponseCallback<Schema$WriteResult>): void;
        update(callback: BodyResponseCallback<Schema$WriteResult>): void;
    }
    interface Params$Resource$States$Clear extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The version of the data to be cleared. Version strings are returned by
         * the server.
         */
        currentDataVersion?: string;
        /**
         * The key for the data to be retrieved.
         */
        stateKey?: number;
    }
    interface Params$Resource$States$Delete extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The key for the data to be retrieved.
         */
        stateKey?: number;
    }
    interface Params$Resource$States$Get extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The key for the data to be retrieved.
         */
        stateKey?: number;
    }
    interface Params$Resource$States$List extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Whether to include the full data in addition to the version number
         */
        includeData?: boolean;
    }
    interface Params$Resource$States$Update extends StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The version of the app state your application is attempting to update. If
         * this does not match the current version, this method will return a
         * conflict error. If there is no data stored on the server for this key,
         * the update will succeed irrespective of the value of this parameter.
         */
        currentStateVersion?: string;
        /**
         * The key for the data to be retrieved.
         */
        stateKey?: number;
        /**
         * Request body metadata
         */
        requestBody?: Schema$UpdateRequest;
    }
}
